//Game Lobby
//Simulates a game lobby where players wait

#include <iostream>
#include <string>

using namespace std;

class Player
{
public:
    Player(const string& name = "");
    string GetName() const;
    Player* GetNext() const;
    void SetNext(Player* next);

private:
    string m_Name;
    Player* m_pNext;  //Pointer to next player in list
};

Player::Player(const string& name) :
    m_Name(name),
    m_pNext(0)
{}

string Player::GetName() const
{
    return m_Name;
}

Player* Player::GetNext() const
{
    return m_pNext;
}

void Player::SetNext(Player* next)
{
    m_pNext = next;
}

class Lobby
{
    friend ostream& operator<<(ostream& os, const Lobby& aLobby);

public:
    Lobby();
    ~Lobby();
    void AddPlayer();
    void RemovePlayer();
    void Clear();
    void findPlayer();
    void sortPlayer();


private:
    Player* m_pHead;
};

Lobby::Lobby() :
    m_pHead(0)
{}

Lobby::~Lobby()
{
    Clear();
}

void Lobby::AddPlayer()
{
    //create a new player node
    cout << "Please enter the name of the new player: ";
    string name;
    cin >> name;
    Player* pNewPlayer = new Player(name);

    //if list is empty, make head of list this new player
    if (m_pHead == 0)
    {
        m_pHead = pNewPlayer;
    }
    //otherwise find the end of the list and add the player there
    else
    {
        Player* pIter = m_pHead;
        while (pIter->GetNext() != 0)
        {
            pIter = pIter->GetNext();
        }
        pIter->SetNext(pNewPlayer);
    }
}

void Lobby::RemovePlayer()
{
    string removePlayer;

    cout << "\nEnter a player you would like to remove: ";
    cin >> removePlayer;

    bool isFound = false;
    bool alreadyChanged = false;
    
    
    Player* pIter = m_pHead;
    Player* pIter2 = m_pHead;

    while (pIter != 0) {
        if (m_pHead->GetName() == removePlayer) {
            Player* pTemp = m_pHead;
            
            m_pHead = m_pHead->GetNext();

            pIter = m_pHead;
            alreadyChanged = true;
            pIter2 = m_pHead;
            isFound = true;

            delete pTemp;
            
        }
        else if (pIter->GetName() == removePlayer) {

            while (pIter2->GetNext() != pIter) {
               pIter2 = pIter2->GetNext();
            }

            pIter2->SetNext(pIter->GetNext());

            delete pIter;

            pIter = m_pHead;

            isFound = true;

            if (pIter2 == 0) {
                pIter2 = m_pHead;
            }
            
        }
        
        if (pIter != 0 && alreadyChanged == false) {
            pIter = pIter->GetNext();
        }
        else {
            alreadyChanged = false;
        }
        
            
        }

    if (isFound == false) {
        cout << "\nPlayer is not in the list." << endl;
        }
    
    
        
    
}



void Lobby::Clear()
{
    if (m_pHead == 0)
    {
        cout << "The game lobby is empty.  No one to remove!\n";
    }
    else
    {
        while (m_pHead != 0)
        {
            Player* pTemp = m_pHead;
            m_pHead = m_pHead->GetNext();
            delete pTemp;
        }
    }
}

void Lobby::findPlayer() {
    string getName;
    int counter = 1;
    int foundCounter = 0;

    cout << "Please enter the name of the player you wish to find: ";
    cin >> getName;

    if (m_pHead == 0) {
        cout << "There are no players in the list.\n";
    }
    else {
        Player* pIter = m_pHead;

        while (pIter != 0) {
            if (pIter->GetName() == getName) {
                cout << "Player is found. The player's position is " << counter << "." << endl;
                ++foundCounter;
            }

            pIter = pIter->GetNext();
            counter++;
        }

        if (pIter == 0 && foundCounter == 0) {
            cout << "This player does not exist in this list." << endl;
        }
    }
}


void Lobby::sortPlayer() {
    Player* current = m_pHead;
    Player* previous = m_pHead;
    Player* temp = 0;
    bool sorted = false;

    while (previous != 0) {

        while (current != 0) {

            if (current->GetNext() != 0) {
                temp = current->GetNext();
            }
            else {
                break;
            }

            if (current->GetName() > temp->GetName()) {
                sorted = true;

                if (current == m_pHead) {
                    current->SetNext(temp->GetNext());
                    temp->SetNext(current);
                    previous = temp;
                    
                    m_pHead = previous;
                }
                else {
                    current->SetNext(temp->GetNext());
                    temp->SetNext(current);
                    previous->SetNext(temp->GetNext());
                    previous = temp;
                }

            }
            previous = current;
            current = current->GetNext();
        }

        if (sorted == false) {
            cout << "\nNo Item to sort." << endl;
            break;
        }
        else {
            cout << "\nThe list is sorted." << endl;
        }

        previous = current;
    }


}

ostream& operator<<(ostream& os, const Lobby& aLobby)
{
    Player* pIter = aLobby.m_pHead;

    os << "\nHere's who's in the game lobby:\n";
    if (pIter == 0)
    {
        os << "The lobby is empty.\n";
    }
    else
    {
        while (pIter != 0)
        {
            os << pIter->GetName() << endl;
            pIter = pIter->GetNext();
        }
    }

    return os;
}

int main()
{
    Lobby myLobby;
    int choice;

    do
    {
        cout << myLobby;
        cout << "\nGAME LOBBY\n";
        cout << "0 - Exit the program.\n";
        cout << "1 - Add a player to the lobby.\n";
        cout << "2 - Remove a player from the lobby.\n";
        cout << "3 - Clear the lobby.\n";
        cout << "4 - Find Player.\n";
        cout << "5 - Sort the list.\n";
        cout << endl << "Enter choice: ";
        cin >> choice;

        switch (choice)
        {
        case 0: cout << "Good-bye.\n"; break;
        case 1: myLobby.AddPlayer(); break;
        case 2: myLobby.RemovePlayer(); break;
        case 3: myLobby.Clear(); break;
        case 4: myLobby.findPlayer(); break;
        case 5: myLobby.sortPlayer(); break;
        default: cout << "That was not a valid choice.\n";
        }
    } while (choice != 0);

    return 0;
}
